/*

NFS Carbon Demo Addon Mod
Copyright (C) 2006, Arushan <oneforaru@gmail.com>
Made in Canada. <3

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include <windows.h>
#include <stdio.h>
#include <assert.h>
#include "mempatcher.h"

//----------------------------------------------
// Configuration

typedef struct _tConfig 
{
	BOOL bEnableMod;
	
	BOOL bSkipFE;
	BOOL bSkipLoadScreens;
	CHAR szStartCar[32];

	CHAR szUserExotic[32];
	CHAR szUserMuscle[32];
	CHAR szUserTuner[32];
	BOOL bDisableAutoSculptPatch;

	BOOL bWindowedMode;
	BOOL bDrawWindowFrame;
} tConfig;

tConfig Config;

#define CONFIG_FILE ".\\addon.ini"

BOOL LoadConfig() 
{
	// Verify the configuration file exists
	FILE *f = fopen(CONFIG_FILE, "rt");
	if (!f)
		return FALSE;
	fclose(f);

	// Load the configuration
	Config.bEnableMod = (BOOL)GetPrivateProfileInt("addon", "enable", 0, CONFIG_FILE);

	Config.bSkipFE = (BOOL)GetPrivateProfileInt("game", "skip_fe", 0, CONFIG_FILE);
	Config.bSkipLoadScreens = (BOOL)GetPrivateProfileInt("game", "skip_load_screens", 
		0, CONFIG_FILE);
	GetPrivateProfileString("game", "start_car", "gallardo", 
		Config.szStartCar, sizeof(Config.szStartCar), CONFIG_FILE);

	GetPrivateProfileString("cars", "exotic", "USER_EXOTIC", 
		Config.szUserExotic, sizeof(Config.szUserExotic), CONFIG_FILE);
	GetPrivateProfileString("cars", "muscle", "USER_MUSCLE", 
		Config.szUserMuscle, sizeof(Config.szUserMuscle), CONFIG_FILE);
	GetPrivateProfileString("cars", "tuner", "USER_TUNER", 
		Config.szUserTuner, sizeof(Config.szUserTuner), CONFIG_FILE);

	Config.bDisableAutoSculptPatch = (BOOL)GetPrivateProfileInt("cars", 
		"disable_patch_autosculpt", 0, CONFIG_FILE);
	

	Config.bWindowedMode = (BOOL)GetPrivateProfileInt("windowed", "enable", 0, CONFIG_FILE);
	Config.bDrawWindowFrame = (BOOL)GetPrivateProfileInt("windowed", "drawframe", 0, CONFIG_FILE);

	return TRUE;
}

//----------------------------------------------
// Car Definitions Stuff

#define _PAD(a,b) BYTE _##a[b]

typedef struct _tGameCarDefn
{
	CHAR szCarName[32];
	CHAR szDefnName[32];
	LONGLONG qHashFE;		// hash in VLT database (frontend)
	LONGLONG qHashPVeh;		// hash in VLT database (pvehicle)
	_PAD(pad1, 0x58-0x50);
	DWORD dwBaseHash;		// _BASE
	_PAD(pad2, 0x10C-0x5C);
	DWORD dwDriverHash;
	_PAD(pad3, 0x190-0x110);
	DWORD dwHoodHash;
	_PAD(pad31, 0x1A8-0x194);
	DWORD dwRimStyleHash;
	_PAD(pad4, 0x1B8-0x1AC);				// most likely Decal hashes as well, but couldn't verify
	DWORD dwDecalFrontWindowWideMediumHash;	// _FRONT_WINDOW_WIDE_MEDIUM
	DWORD dwDecalRearWindowWideMediumHash;	// _REAR_WINDOW_WIDE_MEDIUM
	DWORD dwPaintHash;		// i.e. PEARLn_PAINT
	_PAD(pad5, 0x1F0-0x1C4);
	DWORD dwUnknownHash;	
	DWORD dwStockHash;		// STOCK
	_PAD(pad6, 0x248-0x1F8);
	DWORD dwCarType;		// seems like 0x320000 for user cars
	_PAD(pad7, 0x5F8-0x24C);

} tGameCarDefn;

typedef struct _tGameCarDefnList
{
	_tGameCarDefnList*	pPrev;		// First entry when  pPrev == *pCarDefnStart
	_tGameCarDefnList*	pNext;		// Last entry when   pNext == *pCarDefnStart
	tGameCarDefn		CarDef;
} tGameCarDefnList;

tGameCarDefnList **pCarDefnStart = (tGameCarDefnList**)(0x00B7BC24);

BOOL LoadCarDefintionsHook()
{	

	assert(sizeof(tGameCarDefnList)==0x600);

	tGameCarDefnList* defn = *pCarDefnStart;
	while(true) {
		
		if (!Config.bDisableAutoSculptPatch) {
			// Set this so that cars which don't have autosculpt info will
			// atleast be able to autosculpt the wheels.
			defn->CarDef.dwRimStyleHash = 0xfd6de6bc;
		}

		if (defn->pNext == *pCarDefnStart)
			break;

		defn = defn->pNext;
	}

	return TRUE;

}

//----------------------------------------------
// Patcher, Patch Handlers

void __stdcall SetWindowLongHook(HWND hWnd, int nIndex, LONG dwNewLong) 
{
	dwNewLong |= WS_CAPTION | WS_MINIMIZEBOX | WS_SYSMENU;

	// Set the window long
	SetWindowLong(hWnd, nIndex, dwNewLong);

	// Since some window data is cached...
	SetWindowPos(hWnd, 0, 0, 0, 0, 0, 
					SWP_NOSIZE | SWP_NOMOVE | SWP_NOZORDER | SWP_FRAMECHANGED);

}

void InstallPatches() 
{
	
	if (Config.bEnableMod) {

		// Patch the Car Definitions used by the game
		// Since the new value might not fit in the buffers, we'll replace
		// all instances of references to the value (there aren't that many)

		// For Exotic:
		WritePointer(0x004A1D83, Config.szUserExotic);
		WritePointer(0x004A374E, Config.szUserExotic);
		WritePointer(0x004AD89A, Config.szUserExotic);
		WritePointer(0x0064772A, Config.szUserExotic);

		// For Muscle:
		WritePointer(0x004A1D95, Config.szUserMuscle);
		WritePointer(0x004A3736, Config.szUserMuscle);
		WritePointer(0x0064771D, Config.szUserMuscle);

		// For Tuner:
		WritePointer(0x004A1D6B, Config.szUserTuner);
		WritePointer(0x004A371E, Config.szUserTuner);
		WritePointer(0x00647737, Config.szUserTuner);

		// Make the game set itself up in windowed mode 
		// (and create D3D9 PresentParams appropriately)
		if (Config.bWindowedMode) {
			WriteInt32(0x00AB56F4, (int)Config.bWindowedMode);

			// If we make the frame, hook the SetWindowLongA call.
			if (Config.bDrawWindowFrame) {
				// This is a ds: call, so we have 6 bytes - nop one of them.
				WriteNop(0x00731C4A, 1);
				WriteCall(0x00731C4B, SetWindowLongHook);
			}
		}

		// Install a hook for the car definitions loader
		WriteCall(0x007C416E, LoadCarDefintionsHook);

		// Skip the loading movies + frontend screens
		if (Config.bSkipLoadScreens) {
			// Skip the movies
			WriteInt32(0x00AA32F0, 1);

			// Skip the fngs by directing them to the Attract movie ;)
			WriteInt32(0x00849E18, 0x00849DE9);	// DEMO_LEGAL_CAR
			WriteInt32(0x00849E1C, 0x00849DE9); // DEMO_NOTICE
			WriteInt32(0x00849E20, 0x00849DE9); // DEMO_ESRB
			WriteInt32(0x00849E28, 0x00849DE9); // DEMO_LEGAL_MUSIC
		}

		// Skip the frontend
		// This doesn't properly work anymore, although it did in MW.
		// The world doesn't get loaded. :/
		if (Config.bSkipFE) {
			WriteInt32(0x00AA3230, 1);
			WritePointer(0x00A67D14, Config.szStartCar);
		}
		
	}

}

//----------------------------------------------
// DLL Entry Point

HMODULE hD3D9Dll = NULL;
HANDLE hModuleRef;

BOOL APIENTRY DllMain( HANDLE hModule, DWORD  fdwReason, LPVOID lpReserved)
{

	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH: 
		{
			hModuleRef = hModule;

			if (LoadConfig())
				InstallPatches();

			break;
		}
		case DLL_PROCESS_DETACH:
		{
			if (hModule == hModuleRef) {
				if (hD3D9Dll != NULL) {
					FreeLibrary(hD3D9Dll);
				}
			}
			break;
		}
	}

    return TRUE;
}

//----------------------------------------------
// Hook for loading real D3D9.dll

typedef void* (WINAPI *Direct3DCreate9_t)(UINT SDKVersion);

void* WINAPI Direct3DCreate9Hook(UINT SDKVersion)
{

	CHAR path[MAX_PATH];
	GetSystemDirectory(path, MAX_PATH);
	strcat(path, "\\d3d9.dll");
	hD3D9Dll = LoadLibrary(path);

	if (!hD3D9Dll) {
		
		MessageBox(0, "Failed to load d3d9.dll", "Error", MB_ICONERROR | MB_OK);
		return NULL;

	} else {

		Direct3DCreate9_t Direct3DCreateProc = (Direct3DCreate9_t)GetProcAddress(hD3D9Dll, "Direct3DCreate9");
		return Direct3DCreateProc(SDKVersion);

	}

}