/*

NFS Carbon Demo Addon Mod
Copyright (C) 2006, Arushan <oneforaru@gmail.com>
Made in Canada. <3

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "windows.h"
#include "mempatcher.h"

void WriteString(unsigned int offset, char* value) {
	char *pValue = (char*)(offset);

	int len = strlen(value) + 1;

	DWORD d,ds;
	VirtualProtect(pValue,len,PAGE_EXECUTE_READWRITE,&d);
	strcpy(pValue, value);
	VirtualProtect(pValue,len,d,&ds);
}

void WritePointer(unsigned int offset, void* value) {
	void **pValue = (void**)(offset);

	DWORD d,ds;
	VirtualProtect(pValue,sizeof(int),PAGE_EXECUTE_READWRITE,&d);
	*pValue = value;
	VirtualProtect(pValue,sizeof(int),d,&ds);
}

void WriteInt32(unsigned int offset, int value) {
	unsigned int *pValue = (unsigned int*)(offset);

	DWORD d,ds;
	VirtualProtect(pValue,sizeof(int),PAGE_EXECUTE_READWRITE,&d);
	*pValue = value;
	VirtualProtect(pValue,sizeof(int),d,&ds);
}

void WriteInt8(unsigned int offset, unsigned char value) {
	unsigned char *pValue = (unsigned char*)(offset);

	DWORD d,ds;
	VirtualProtect(pValue,sizeof(char),PAGE_EXECUTE_READWRITE,&d);
	*pValue = value;
	VirtualProtect(pValue,sizeof(char),d,&ds);
}

void WriteFloat(unsigned int offset, float value) {
	float *pValue = (float*)(offset);

	DWORD d,ds;
	VirtualProtect(pValue,sizeof(char),PAGE_EXECUTE_READWRITE,&d);
	*pValue = value;
	VirtualProtect(pValue,sizeof(char),d,&ds);
}

void WriteNop(unsigned int offset, int count) {
	unsigned char *pValue = (unsigned char*)(offset);

	DWORD d,ds;
	VirtualProtect(pValue,count,PAGE_EXECUTE_READWRITE,&d);
	for(int i=0; i<count; i++)
	{
		*pValue = 0x90;
		pValue++;
	}
	VirtualProtect(pValue,sizeof(char),d,&ds);
}

void WriteJmp(unsigned int srcOffset, void* targetFn) {

	unsigned int disp = (unsigned int)targetFn - (srcOffset + 5);
	WriteInt8(srcOffset, 0xE9);
	WriteInt32(srcOffset+1, disp);

}

void WriteDisp(unsigned int srcOffset, void* targetFn) {

	unsigned int disp = (unsigned int)targetFn - (srcOffset + 4);
	WriteInt32(srcOffset, disp);

}


void WriteCall(unsigned int srcOffset, void* targetFn) {

	unsigned int disp = (unsigned int)targetFn - (srcOffset + 5);
	WriteInt8(srcOffset, 0xE8);
	WriteInt32(srcOffset+1, disp);

}