// all the compression algorithms

#include "unlzss.h"
typedef unsigned short  word;   // for sflcomp
#include "sflcomp.h"
int unlzx(unsigned char *in, int insz, unsigned char *out, int outsz);
int unmslzx(unsigned char *in, int insz, unsigned char *out, int outsz, int window_bits, int interval);
int lzssboh_decode(unsigned char *in, int insz, unsigned char *out, int outsz);
uint32_t unlzw(uint8_t *outbuff, uint32_t maxsize, uint8_t *in, uint32_t insize);
uint32_t unlzwx(uint8_t *outbuff, uint32_t maxsize, uint8_t *in, uint32_t insize);



int unlzo(u8 *in, int insz, u8 *out, int outsz, int type) {
#ifdef DISABLE_LZO
    printf("\nError: LZO support has been disabled in this build\n");
    myexit(-1);
#else
    static u8   *wrkmem = NULL; // totally useless, I declare it only in case of future updates of lzo
    lzo_uint    len;
    int         err = LZO_E_OK;

    len = outsz;
    switch(type) {
        case COMP_LZO1:  { /* wrkmem = malloc(LZO1_MEM_DECOMPRESS);  */ err = lzo1_decompress(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1A: { /* wrkmem = malloc(LZO1A_MEM_DECOMPRESS); */ err = lzo1a_decompress(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1B: { /* wrkmem = malloc(LZO1B_MEM_DECOMPRESS); */ err = lzo1b_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1C: { /* wrkmem = malloc(LZO1C_MEM_DECOMPRESS); */ err = lzo1c_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1F: { /* wrkmem = malloc(LZO1F_MEM_DECOMPRESS); */ err = lzo1f_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1X: { /* wrkmem = malloc(LZO1X_MEM_DECOMPRESS); */ err = lzo1x_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1Y: { /* wrkmem = malloc(LZO1Y_MEM_DECOMPRESS); */ err = lzo1y_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO1Z: { /* wrkmem = malloc(LZO1Z_MEM_DECOMPRESS); */ err = lzo1z_decompress_safe(in, insz, out, &len, wrkmem); break; }
        case COMP_LZO2A: { /* wrkmem = malloc(LZO2A_MEM_DECOMPRESS); */ err = lzo2a_decompress_safe(in, insz, out, &len, wrkmem); break; }
        default: {
            printf("\nError: unsupported LZO decompression %d\n", type);
            myexit(-1);
            break;
        }
    }
    if((err != LZO_E_OK) && (err != LZO_E_INPUT_NOT_CONSUMED)) {
        printf("\nError: the compressed LZO input is wrong or incomplete (%d)\n", err);
        myexit(-1);
    }
    return(len);
#endif
}



int unzip(int wbits, u8 *in, int insz, u8 *out, int outsz) {
    static z_stream *z  = NULL;

    if(!in && !out) {
        if(z) {
            inflateEnd(z);
            free(z);
        }
        z = NULL;
        return(-1);
    }

    if(!z) {
        z = malloc(sizeof(z_stream));
        if(!z) STD_ERR;
        z->zalloc = (alloc_func)0;
        z->zfree  = (free_func)0;
        z->opaque = (voidpf)0;
        if(inflateInit2(z, wbits)) {
            printf("\nError: zlib initialization error\n");
            myexit(-1);
        }
    }
    inflateReset(z);

    z->next_in   = in;
    z->avail_in  = insz;
    z->next_out  = out;
    z->avail_out = outsz;
    if(inflate(z, Z_FINISH) != Z_STREAM_END) {
        printf("\nError: the compressed zlib/deflate input is wrong or incomplete\n");
        myexit(-1);
    }
    return(z->total_out);
}



int unbzip2(u8 *in, int insz, u8 *out, int outsz) { // no reset in bzlib
    int     err;

    err = BZ2_bzBuffToBuffDecompress(out, &outsz, in, insz, 0, 0);
    if(err != BZ_OK) {
        fprintf(stderr, "\nError: invalid bz2 compressed data (%d)\n", err);
        exit(1);
    }
    return(outsz);
}



int unxmemlzx(u8 *in, int insz, u8 *out, int outsz) {
#ifdef WIN32
    typedef VOID*                       XMEMDECOMPRESSION_CONTEXT;
    typedef enum _XMEMCODEC_TYPE {
        XMEMCODEC_DEFAULT =             0,
        XMEMCODEC_LZX =                 1
    } XMEMCODEC_TYPE;
    HRESULT WINAPI XMemCreateDecompressionContext(
        XMEMCODEC_TYPE                  CodecType,
        CONST VOID*                     pCodecParams,
        DWORD                           Flags,
        XMEMDECOMPRESSION_CONTEXT*      pContext
    );
    HRESULT WINAPI XMemDecompress(
        XMEMDECOMPRESSION_CONTEXT       Context,
        VOID*                           pDestination,
        SIZE_T*                         pDestSize,
        CONST VOID*                     pSource,
        SIZE_T                          SrcSize
    );

    static XMEMDECOMPRESSION_CONTEXT ctx = NULL;
    SIZE_T  ret;
    HRESULT hr;

    if(!ctx) {
        hr = XMemCreateDecompressionContext(
            XMEMCODEC_DEFAULT,
            NULL,
            0,
            &ctx);
        if(hr != S_OK) return(-1);
    }
    // XMemResetDecompressionContext is used only for the streams

    ret = outsz;
    hr = XMemDecompress(ctx, out, &ret, in, insz);

    // XMemDestroyDecompressionContext(ctx);
    if(hr != S_OK) return(-1);
    return(ret);
#else
    printf("\nError: XMemDecompress is implemented only on Windows\n");
    myexit(-1);
    return(-1);
#endif
}



int unhex(u8 *in, int insz, u8 *out, int outsz) {
    int     c;
    u8      *inl,
            *outl,
            *p;

    p    = out;
    outl = out + outsz;
    inl  = in + insz;
    while(in < inl) {
        c = hex2byte(in);
        if(c < 0) {
            in++;
        } else {
            if(p >= outl) break;
            *p++ = c;
            in += 2;
        }
    }
    return(p - out);
}



int unbase64(u8 *in, int insz, u8 *out, int outsz) {
    int     xlen,
            a   = 0,
            b   = 0,
            c,
            step;
    u8      *limit,
            *data,
            *p;
    static const u8 base[128] = {   // supports also the Gamespy base64
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x3f,
        0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,
        0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x3e,0x00,0x3f,0x00,0x00,
        0x00,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
        0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x30,0x31,0x32,0x33,0x00,0x00,0x00,0x00,0x00
    };

    if(insz < 0) insz = strlen(in);
    xlen = ((insz >> 2) * 3) + 1;    // NULL included in output for text
    if(outsz < xlen) return(-1);
    data = in;

    p = out;
    limit = data + insz;

    for(step = 0; /* data < limit */; step++) {
        do {
            if(data >= limit) {
                c = 0;
                break;
            }
            c = *data;
            data++;
            if((c == '=') || (c == '_')) {  // supports also the Gamespy base64
                c = 0;
                break;
            }
        } while(c && ((c <= ' ') || (c > 0x7f)));
        if(!c) break;

        switch(step & 3) {
            case 0: {
                a = base[c];
                break;
            }
            case 1: {
                b = base[c];
                *p++ = (a << 2)        | (b >> 4);
                break;
            }
            case 2: {
                a = base[c];
                *p++ = ((b & 15) << 4) | (a >> 2);
                break;
            }
            case 3: {
                *p++ = ((a & 3) << 6)  | base[c];
                break;
            }
        }
    }
    *p = 0;
    return(p - out);
}



int unexplode(u8 *in, int insz, u8 *out, int outsz) {
typedef struct {
    u8      *in;
    int     insz;
    int     outsz;
} explode_info_t;

unsigned explode_read(void *how, unsigned char **buf) {
    explode_info_t *explode_info;

    explode_info = (explode_info_t *)how;
    *buf = explode_info->in;
    return(explode_info->insz);
}
int explode_write(void *how, unsigned char *buf, unsigned len) {
    explode_info_t *explode_info;

    explode_info = (explode_info_t *)how;
    explode_info->outsz = len;
    return(0);
}

    explode_info_t explode_info;

    explode_info.in    = in;
    explode_info.insz  = insz;
    explode_info.outsz = -1;

    blast(explode_read, &explode_info, explode_write, &explode_info, out, outsz);
    return(explode_info.outsz);
}



int unlzma(u8 *in, int insz, u8 **ret_out, int outsz, int lzma_flags, int *full_outsz) {
void *SzAlloc(void *p, size_t size) { return(malloc(size)); }
void SzFree(void *p, void *address) { free(address); }
ISzAlloc g_Alloc = { SzAlloc, SzFree };

    CLzmaDec    lzma;
    ELzmaStatus status;
    SizeT   inlen,
            outlen;
    int     x86State,
            filter  = 0;
    u8      *out;

    if(lzma_flags & LZMA_FLAGS_86_DECODER) {
        if(insz < 1) return(-1);
        filter = in[0];
        in++;
        insz--;
    }

    if(insz < LZMA_PROPS_SIZE) return(-1);
    LzmaDec_Construct(&lzma);
    LzmaDec_Allocate(&lzma, in, LZMA_PROPS_SIZE, &g_Alloc);
    LzmaDec_Init(&lzma);

    in   += LZMA_PROPS_SIZE;
    inlen = insz - LZMA_PROPS_SIZE;

    out = *ret_out;
    if(lzma_flags & LZMA_FLAGS_86_HEADER) {
        if(insz < 8) return(-1);
        outsz = in[0] | (in[1] << 8) | (in[2] << 16) | (in[3] << 24);   // 64 bit not supported yet
        myalloc(&out, outsz, full_outsz);
        *ret_out = out;
        in   += 8;
        inlen = insz - 8;
    }
    outlen = outsz;

    if(
        (LzmaDec_DecodeToBuf(&lzma, out, &outlen, in, &inlen, LZMA_FINISH_END, &status) != SZ_OK)
     || ((status != LZMA_STATUS_FINISHED_WITH_MARK) && (status != LZMA_STATUS_MAYBE_FINISHED_WITHOUT_MARK))) {
        printf("\nError: the compressed LZMA input is wrong or incomplete (%d)\n", status);
        myexit(-1);
    }
    if(filter) {
        x86_Convert_Init(x86State);
        x86_Convert(out, outlen, 0, &x86State, 0);
    }
    LzmaDec_Free(&lzma, &g_Alloc);
    return(outlen);
}



#define LZMA2_PROPS_SIZE    1
int unlzma2(u8 *in, int insz, u8 **ret_out, int outsz, int lzma_flags, int *full_outsz) {
void *SzAlloc(void *p, size_t size) { return(malloc(size)); }
void SzFree(void *p, void *address) { free(address); }
ISzAlloc g_Alloc = { SzAlloc, SzFree };

    CLzma2Dec    lzma2;
    ELzmaStatus status;
    SizeT   inlen,
            outlen;
    int     x86State,
            filter  = 0;
    u8      *out;

    if(lzma_flags & LZMA_FLAGS_86_DECODER) {
        if(insz < 1) return(-1);
        filter = in[0];
        in++;
        insz--;
    }

    if(insz < LZMA2_PROPS_SIZE) return(-1);
    Lzma2Dec_Construct(&lzma2);
    Lzma2Dec_Allocate(&lzma2, in[0], &g_Alloc);
    Lzma2Dec_Init(&lzma2);

    in   += LZMA2_PROPS_SIZE;
    inlen = insz - LZMA2_PROPS_SIZE;

    out = *ret_out;
    if(lzma_flags & LZMA_FLAGS_86_HEADER) {
        if(insz < 8) return(-1);
        outsz = in[0] | (in[1] << 8) | (in[2] << 16) | (in[3] << 24);   // 64 bit not supported yet
        myalloc(&out, outsz, full_outsz);
        *ret_out = out;
        in   += 8;
        inlen = insz - 8;
    }
    outlen = outsz;

    if(
        (Lzma2Dec_DecodeToBuf(&lzma2, out, &outlen, in, &inlen, LZMA_FINISH_END, &status) != SZ_OK)
     || ((status != LZMA_STATUS_FINISHED_WITH_MARK) && (status != LZMA_STATUS_MAYBE_FINISHED_WITHOUT_MARK))) {
        printf("\nError: the compressed LZMA input is wrong or incomplete (%d)\n", status);
        myexit(-1);
    }
    if(filter) {
        x86_Convert_Init(x86State);
        x86_Convert(out, outlen, 0, &x86State, 0);
    }
    Lzma2Dec_Free(&lzma2, &g_Alloc);
    return(outlen);
}



int ungzip(u8 *in, int insz, u8 **ret_out, int *full_outsz) {
    int     fsize;
    u8      flags,
            *limit,
            *out;

    if(insz < 14) return(-1);
    limit = in + insz;
    fsize = getxx(limit - 4, 4);

    if((in[0] != 0x1f) && (in[1] != 0x8b)) return(-1);
    in += 2;        // id1/id2
    in++;           // cm
    flags = *in++;  // flg
    in += 4;        // mtime
    in++;           // xfl
    in++;           // os
    if(flags & 4) {
        in += 2 + (in[0] | (in[1] << 8));
        if(in > limit) return(-1);
    }
    if(flags & 8)  in += strlen(in) + 1;
    if(flags & 16) in += strlen(in) + 1;
    if(flags & 2)  in += 2;
    if(in > limit) return(-1);

    out = *ret_out;
    myalloc(&out, fsize, full_outsz);
    *ret_out = out;
    insz = limit - in;
    return(unzip(-15, in, insz, out, fsize));
}



// reversed from AIM Racing
int unrlew(u8 *in, int insz, u8 *out, int outsz) {
#define RLEW_GET16  if((i + 2) > insz) return(-1); \
                    c = in[i];          i++; \
                    c |= (in[i] << 8);  i++;
#define RLEW_PUT16  if((o + 2) > outsz) return(-1); \
                    out[o] = c;         o++; \
                    out[o] = c >> 8;    o++;

    int     i,
            o,
            c,
            n,
            mask;

    o = 0;
    mask = in[0] << 8;
    for(i = 2; i < insz;) {
        RLEW_GET16
        if((c & 0xff00) == mask) {
            if(c == (mask | 0xff)) {
                RLEW_GET16
                RLEW_PUT16
            } else {
                n = (c & 0xff) + 3;
                RLEW_GET16
                while(n > 0) {
                    RLEW_PUT16
                    n--;
                }
            }
        } else {
            RLEW_PUT16
        }
    }
    return(o);
}



// modified from http://cvs.opensolaris.org/source/xref/onnv/onnv-gate/usr/src/uts/common/fs/zfs/lzjb.c
#define NBBY 8
#define	MATCH_BITS	6
#define	MATCH_MIN	3
#define	MATCH_MAX	((1 << MATCH_BITS) + (MATCH_MIN - 1))
#define	OFFSET_MASK	((1 << (16 - MATCH_BITS)) - 1)
#define	LEMPEL_SIZE	256

int
lzjb_decompress(u8 *s_start, u8 *d_start, size_t s_len, size_t d_len)
{
	u8 *src = s_start;
	u8 *dst = d_start;
	u8 *d_end = (u8 *)d_start + d_len;
	u8 *cpy, copymap = 0;
	int copymask = 1 << (NBBY - 1);

	while (dst < d_end) {
		if ((copymask <<= 1) == (1 << NBBY)) {
			copymask = 1;
			copymap = *src++;
		}
		if (copymap & copymask) {
			int mlen = (src[0] >> (NBBY - MATCH_BITS)) + MATCH_MIN;
			int offset = ((src[0] << NBBY) | src[1]) & OFFSET_MASK;
			src += 2;
			if ((cpy = dst - offset) < (u8 *)d_start)
				return (-1);
			while (--mlen >= 0 && dst < d_end)
				*dst++ = *cpy++;
		} else {
			*dst++ = *src++;
		}
	}
	return (dst - d_start);
}


