// modified by Luigi Auriemma, original on http://oku.edu.mie-u.ac.jp/~okumura/compression/lzss.c
// I don't know what exact LZSS version/type it is but differs than the most commonly used one
/* LZSS encoder-decoder  (c) Haruhiko Okumura */

#include <stdio.h>
#include <stdlib.h>

#define EI 11  /* typically 10..13 */
#define EJ  4  /* typically 4..5 */
#define P   1  /* If match length <= P then output one character */
#define N (1 << EI)  /* buffer size */
#define F ((1 << EJ) + P)  /* lookahead buffer size */

int bit_buffer = 0, bit_mask = 128;
unsigned char buffer[N * 2];

int getbit(unsigned char **in, unsigned char *inl, int n) /* get n bits */
{
    int i, x;
    static int buf, mask = 0;
    
    x = 0;
    for (i = 0; i < n; i++) {
        if (mask == 0) {
            if(*in >= inl) return(-1);
            buf = **in;
            (*in)++;
            mask = 128;
        }
        x <<= 1;
        if (buf & mask) x++;
        mask >>= 1;
    }
    return x;
}

int lzssboh_decode(unsigned char *in, int insz, unsigned char *out, int outsz)
{
    int i, j, k, r, c, len;
    unsigned char   *inl;

    inl = in + insz;
    len = 0;
    for (i = 0; i < N - F; i++) buffer[i] = ' ';
    r = N - F;
    while ((c = getbit(&in, inl, 1)) != -1) {
        if (c) {
            if ((c = getbit(&in, inl, 8)) == -1) break;
            if(len >= outsz) return(-1);
            out[len++] = c;
            buffer[r++] = c;  r &= (N - 1);
        } else {
            if ((i = getbit(&in, inl, EI)) == -1) break;
            if ((j = getbit(&in, inl, EJ)) == -1) break;
            for (k = 0; k <= j + 1; k++) {
                c = buffer[(i + k) & (N - 1)];
                if(len >= outsz) return(-1);
                out[len++] = c;
                buffer[r++] = c;  r &= (N - 1);
            }
        }
    }
    return(len);
}
